/// <reference types="node" />
import { RequestOptions } from "http";
import { Json } from "./safe-json-parse.js";
/**
 * Interface for Request Options, that adds one additional option to the Node.js standard RequestOptions,
 * "responseTimeout", with which a timeout can be set within which the response must be received.
 * (Note the "timeout" in the Node.js standard RequestOptions, concerns something else: the socket idle timeout)
 */
type FetchRequestOptions = RequestOptions & {
    responseTimeout?: number;
};
/**
 * Execute a HTTPS request
 * @param uri - The URI
 * @param requestOptions - The RequestOptions to use
 * @param data - Data to send to the URI (e.g. POST data)
 * @returns - The response as parsed JSON
 */
export declare function fetchJson<ResultType extends Json>(uri: string, requestOptions?: FetchRequestOptions, data?: Uint8Array): Promise<ResultType>;
export {};
