/// <reference types="node" />
import { Json } from "./safe-json-parse.js";
/**
 * Execute a HTTPS request
 * @param uri - The URI
 * @param requestOptions - The RequestOptions to use (depending on the runtime context, either Node.js RequestOptions or Web Fetch init)
 * @param data - Data to send to the URI (e.g. POST data)
 * @returns - The response as parsed JSON
 */
export declare const fetchJson: <ResultType extends Json>(uri: string, requestOptions?: Record<string, unknown> | undefined, data?: Uint8Array | undefined) => Promise<ResultType>;
type FetchRequestOptions = Record<string, unknown>;
/** Interface for JS objects that can be used with the SimpleJsonFetcher */
export interface JsonFetcher<ResultType extends Json = Json> {
    fetch: (uri: string, requestOptions?: FetchRequestOptions, data?: Buffer) => Promise<ResultType>;
}
/**
 * HTTPS Fetcher for URIs with JSON body
 *
 * @param defaultRequestOptions - The default RequestOptions to use on individual HTTPS requests
 */
export declare class SimpleJsonFetcher implements JsonFetcher {
    defaultRequestOptions: FetchRequestOptions;
    constructor(props?: {
        defaultRequestOptions?: FetchRequestOptions;
    });
    /**
     * Execute a HTTPS request (with 1 immediate retry in case of errors)
     * @param uri - The URI
     * @param requestOptions - The RequestOptions to use
     * @param data - Data to send to the URI (e.g. POST data)
     * @returns - The response as parsed JSON
     */
    fetch<ResultType extends Json>(uri: string, requestOptions?: FetchRequestOptions, data?: Uint8Array): Promise<ResultType>;
}
export {};
